/*********************************************************************************************************
* Donohue and Wolfers (2006) 
* Table 7
* Estimating the Effect of Executions on Murder Rates and Net Lives Saved: 
* Testing the Sensitivity of the Dezhbakhsh, Rubin, and Shepherd (DRS) Estimates: 1977-1996
*********************************************************************************************************/

clear
set more off
set mem 800m
set mat 800
cd "..."
program drop _all

program define setlags
* Program creates the variables required for models 4-6
	drop if YEAR==76
	drop if COUNTY==51570 & YEAR==80 & MURDO1==0
 	tsset COUNTY YEAR
	* But I'll butcher it slightly
 	egen yr=rank(YEAR), by(COUNTY)
 	tsset COUNTY yr
 	sort COUNTY yr
	* Prepare Table 5 variables
	for Q in any PAMURC PEXECF PEXECP PEXECA PSENTP PSENTF PSENTA: gen Qb=Q
	replace PAMURCb=. if MURDO1==0 & AMUR~=.
	for Q in any PAMURC PEXECF PEXECP PEXECA: for Z in num 1/6: gen QZb=lZ.Qb if Qb==.
	for Z in num 1/6: replace PEXECFZb=0 if PEXECFZb==. & YEAR-Z<77
	for Z in num 1/6: replace PAMURCb=PAMURCZb if PAMURCb==. & MURDO1==0 & AMUR~=.
	for Z in num 1/6: for Q in any PEXECF PEXECP PEXECA: replace Qb=QZb if Qb==.
end

program define firststage
	* First Stage, Table 4
	areg  PAMURC POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PAMURCP2 , xbd

	areg  PSENTP POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTPP2 , xbd
	areg  PSENTF POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTFP2 , xbd
	areg  PSENTA POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC] if (FIPSSTAT==4 & (YEAR==82 | YEAR==83))~=1, absorb(COUNTY) 
	predict PSENTAP2, xbd

	areg  PEXECP POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECPP2, xbd
	areg  PEXECF POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECFP2, xbd
	areg  PEXECA POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECAP2, xbd

	* First stage, Table 5
	areg  PAMURCb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PAMURCP2b , xbd

	areg  PSENTPb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTPP2b , xbd
	areg  PSENTFb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PSENTFP2b , xbd
	areg  PSENTAb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC] if (FIPSSTAT==4 & (YEAR==82 | YEAR==83))~=1, absorb(COUNTY) 
	predict PSENTAP2b, xbd

	areg  PEXECPb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECPP2b, xbd
	areg  PEXECFb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECFP2b, xbd
	areg  PEXECAb POLEXPD JLEXPD RATAGA RATROB NRARATE PRISADM vote1 vote2 vote3 vote4 vote5 vote6 DENSITYM RPCIM RPCUI RPCPI PP1019 PP2029 PPB PPN PPM  IYEAR* [aweight=POPC], absorb(COUNTY) 
	predict double PEXECAP2b, xbd
end

program define secondstage
	* Table 4 of DRS
	areg RATMUR RATAGA RATROB PAMURCP2 PSENTPP2 PEXECPP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECPP2]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2]+1.96*_se[PEXECPP2])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2]-1.96*_se[PEXECPP2])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2 PSENTFP2 PEXECFP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECFP2]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2]+1.96*_se[PEXECFP2])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2]-1.96*_se[PEXECFP2])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2 PSENTAP2 PEXECAP2 PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECAP2]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2]+1.96*_se[PEXECAP2])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2]-1.96*_se[PEXECAP2])*((2293)/38)/(320/38)-1

	* Table 5 of DRS
	areg RATMUR RATAGA RATROB PAMURCP2b PSENTPP2b PEXECPP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECPP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2b]+1.96*_se[PEXECPP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECPP2b]-1.96*_se[PEXECPP2b])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2b PSENTFP2b PEXECFP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECFP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2b]+1.96*_se[PEXECFP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECFP2b]-1.96*_se[PEXECFP2b])*((2293)/38)/(320/38)-1
	areg RATMUR RATAGA RATROB PAMURCP2b PSENTAP2b PEXECAP2b PP1019 PP2029 PPB PPN PPM NRARATE RPCPI RPCIM RPCUI DENSITYM  IYEAR* [aweight=POPC], absorb(COUNTY)  
	lincom -_b[PEXECAP2b]*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2b]+1.96*_se[PEXECAP2b])*((2293)/38)/(320/38)-1
	lincom -(_b[PEXECAP2b]-1.96*_se[PEXECAP2b])*((2293)/38)/(320/38)-1
end

*Panels A and B
use CPcounty5_send.dta, clear
setlags
firststage
secondstage

*Panel C
use CPcounty5_send.dta, clear
gen vote=vote1+vote2+vote3+vote4+vote5+vote6
for num 1/6: replace voteX=vote
setlags
firststage
secondstage

*Panel D
use CPcounty5_send.dta, clear
drop if FIPSST==48
setlags
firststage
secondstage

*Panel E
use CPcounty5_send.dta, clear
drop if FIPSST==6
setlags
firststage
secondstage
